/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.response;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.fortuna.ical4j.connector.dav.property.CardDavPropertyName;
import net.fortuna.ical4j.connector.dav.response.AbstractResponseHandler;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilder;
import org.apache.http.HttpResponse;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;

public class GetVCardData
extends AbstractResponseHandler<List<VCard>> {
    public List<VCard> handleResponse(HttpResponse response) {
        try {
            MultiStatus multiStatus = this.getMultiStatus(response);
            return Arrays.stream(multiStatus.getResponses()).filter(msr -> msr.getProperties(200).get(CardDavPropertyName.ADDRESS_DATA) != null).map(msr -> {
                String value = (String)msr.getProperties(200).get(CardDavPropertyName.ADDRESS_DATA).getValue();
                try {
                    return new VCardBuilder((Reader)new StringReader(value)).build();
                }
                catch (IOException | ParserException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (DavException e) {
            throw new RuntimeException(e);
        }
    }
}

