/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.jcr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.parameter.FmtType;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.Calendars;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcrom.AbstractJcrEntity;
import org.jcrom.JcrDataProvider;
import org.jcrom.JcrDataProviderImpl;
import org.jcrom.JcrFile;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.annotations.JcrProperty;

public class JcrCalendar
extends AbstractJcrEntity {
    private static final Log LOG = LogFactory.getLog(JcrCalendar.class);
    private static final long serialVersionUID = -2711620225884358385L;
    @JcrFileNode
    private JcrFile file;
    @JcrProperty
    private String uid;
    @JcrProperty
    private String summary;
    @JcrFileNode
    private JcrFile description;
    @JcrFileNode
    private final List<JcrFile> attachments = new ArrayList<JcrFile>();
    private Calendar calendar;

    public final Calendar getCalendar() throws IOException, ParserException {
        if (this.calendar == null) {
            CalendarBuilder builder = new CalendarBuilder();
            this.calendar = builder.build(this.file.getDataProvider().getInputStream());
        }
        return this.calendar;
    }

    public final void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        try {
            Uid uidProp = Calendars.getUid((Calendar)calendar);
            this.uid = uidProp.getValue();
            this.setName(uidProp.getValue());
        }
        catch (ConstraintViolationException e) {
            LOG.error((Object)"Invalid UID", (Throwable)e);
            this.setName("calendar");
        }
        this.file = new JcrFile();
        this.file.setName("data");
        this.file.setDataProvider((JcrDataProvider)new JcrDataProviderImpl(calendar.toString().getBytes()));
        this.file.setMimeType(Calendars.getContentType((Calendar)calendar, null));
        this.file.setLastModified(java.util.Calendar.getInstance());
        for (Object component : calendar.getComponents()) {
            Description descriptionProp;
            Summary summaryProp;
            if (this.summary == null && (summaryProp = (Summary)((Component)component).getProperty("SUMMARY")) != null) {
                this.summary = summaryProp.getValue();
            }
            if (this.description == null && (descriptionProp = (Description)((Component)component).getProperty("DESCRIPTION")) != null) {
                this.description = new JcrFile();
                this.description.setName("text");
                this.description.setMimeType("text/plain");
                this.description.setDataProvider((JcrDataProvider)new JcrDataProviderImpl(descriptionProp.getValue().getBytes()));
                this.description.setLastModified(java.util.Calendar.getInstance());
            }
            this.attachments.clear();
            PropertyList attachments = ((Component)component).getProperties(new String[]{"ATTACH"});
            for (Object attach : attachments) {
                try {
                    JcrFile attachment = new JcrFile();
                    attachment.setName("attachment");
                    if (Value.BINARY.equals((Object)((Property)attach).getParameter("VALUE"))) {
                        attachment.setDataProvider((JcrDataProvider)new JcrDataProviderImpl(((Attach)attach).getBinary()));
                        FmtType contentType = (FmtType)((Property)attach).getParameter("FMTTYPE");
                        if (contentType != null) {
                            attachment.setMimeType(contentType.getValue());
                        }
                    } else {
                        ByteArrayOutputStream aout = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)((Attach)attach).getUri().toURL().openStream(), (OutputStream)aout);
                        attachment.setDataProvider((JcrDataProvider)new JcrDataProviderImpl(aout.toByteArray()));
                    }
                    attachment.setLastModified(java.util.Calendar.getInstance());
                    this.attachments.add(attachment);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error saving attachment", (Throwable)e);
                }
            }
        }
    }

    public final String getUid() {
        return this.uid;
    }
}

