/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.jcr;

import java.io.IOException;
import java.util.Calendar;
import net.fortuna.ical4j.connector.MediaType;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilder;
import net.fortuna.ical4j.vcard.property.Uid;
import org.jcrom.AbstractJcrEntity;
import org.jcrom.JcrDataProvider;
import org.jcrom.JcrDataProviderImpl;
import org.jcrom.JcrFile;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.annotations.JcrProperty;

public final class JcrCard
extends AbstractJcrEntity {
    private static final long serialVersionUID = -3268553509872379349L;
    @JcrProperty
    private String uid;
    @JcrFileNode
    private JcrFile file;
    private VCard card;

    public VCard getCard() throws IOException, ParserException {
        if (this.card == null) {
            VCardBuilder builder = new VCardBuilder(this.file.getDataProvider().getInputStream());
            this.card = builder.build();
        }
        return this.card;
    }

    public void setCard(VCard card) {
        this.card = card;
        Uid uidProp = (Uid)card.getProperty(Property.Id.UID);
        if (uidProp != null) {
            this.setName(uidProp.getValue());
            this.uid = uidProp.getValue();
        } else {
            this.setName("card");
        }
        this.file = new JcrFile();
        this.file.setName("data");
        this.file.setDataProvider((JcrDataProvider)new JcrDataProviderImpl(card.toString().getBytes()));
        this.file.setMimeType(MediaType.VCARD_4_0.getContentType());
        this.file.setLastModified(Calendar.getInstance());
    }

    public final String getUid() {
        return this.uid;
    }
}

