/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.local;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Date;
import java.util.Properties;
import net.fortuna.ical4j.connector.ObjectCollection;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.util.Calendars;
import net.fortuna.ical4j.util.ResourceLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocalObjectCollection<T>
implements ObjectCollection<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLocalObjectCollection.class);
    private static final String PROPERTIES_FILE_NAME = ".config";
    private static final String TIMEZONE_FILE_NAME = ".timezone";
    private final File root;
    private final Properties properties;

    public AbstractLocalObjectCollection(File root) {
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("Root must be a directory");
        }
        this.root = root;
        this.properties = new Properties();
        try (InputStream in = ResourceLoader.getResourceAsStream((String)PROPERTIES_FILE_NAME);){
            this.properties.load(in);
        }
        catch (IOException | NullPointerException e) {
            LOG.info("ical4j.properties not found.");
        }
    }

    protected File getRoot() {
        return this.root;
    }

    @Override
    public String getDisplayName() {
        return this.properties.getProperty("DisplayName");
    }

    @Override
    public String getDescription() {
        return this.properties.getProperty("Description");
    }

    public String[] getSupportedComponentTypes() {
        return this.properties.getProperty("SupportedComponents").split(",");
    }

    public Calendar getTimeZone() {
        try {
            return Calendars.load((String)new File(this.root, TIMEZONE_FILE_NAME).getAbsolutePath());
        }
        catch (IOException | ParserException e) {
            LOG.error("Unable to retrieve timezone");
            return null;
        }
    }

    public void setDisplayName(String displayName) throws IOException {
        this.properties.setProperty("DisplayName", displayName);
        this.saveProperties();
    }

    public void setDescription(String description) throws IOException {
        this.properties.setProperty("Description", description);
        this.saveProperties();
    }

    public void setSupportedComponents(String[] supportedComponents) throws IOException {
        this.properties.setProperty("SupportedComponents", StringUtils.join((Object[])supportedComponents, (String)","));
        this.saveProperties();
    }

    public void setTimeZone(Calendar timezone) throws IOException {
        new CalendarOutputter(false).output(timezone, (Writer)new FileWriter(new File(this.root, TIMEZONE_FILE_NAME)));
    }

    private void saveProperties() throws IOException {
        this.properties.store(new FileWriter(new File(this.root, PROPERTIES_FILE_NAME)), String.format("%s", new Date()));
    }
}

