/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.local;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.fortuna.ical4j.connector.ObjectCollection;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStore;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.local.AbstractLocalObjectCollection;
import net.fortuna.ical4j.model.Calendar;

public abstract class AbstractLocalObjectStore<C extends AbstractLocalObjectCollection<?>>
implements ObjectStore<C> {
    private final File root;

    AbstractLocalObjectStore(File root) {
        if (root.exists() && !root.isDirectory()) {
            throw new IllegalArgumentException("Root must be a directory");
        }
        this.root = root;
    }

    protected File getRoot() {
        return this.root;
    }

    @Override
    public boolean connect() throws ObjectStoreException {
        return false;
    }

    @Override
    public boolean connect(String username, char[] password) throws ObjectStoreException {
        return false;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public C addCollection(String id) throws ObjectStoreException {
        File collectionDir = new File(this.root, id);
        if (collectionDir.exists() && !collectionDir.isDirectory() || !collectionDir.exists() && !collectionDir.mkdirs()) {
            throw new ObjectStoreException("Unable to initialise collection");
        }
        ObjectCollection<Object> collection = null;
        try {
            collection = this.getCollection(id);
        }
        catch (ObjectNotFoundException e) {
            collection = this.newCollection(id);
        }
        return (C)collection;
    }

    protected abstract C newCollection(String var1);

    @Override
    public C addCollection(String id, String displayName, String description, String[] supportedComponents, Calendar timezone) throws ObjectStoreException {
        ObjectCollection collection = this.addCollection(id);
        try {
            ((AbstractLocalObjectCollection)collection).setDisplayName(displayName);
            ((AbstractLocalObjectCollection)collection).setDescription(description);
            ((AbstractLocalObjectCollection)collection).setSupportedComponents(supportedComponents);
            ((AbstractLocalObjectCollection)collection).setTimeZone(timezone);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
        return (C)collection;
    }

    @Override
    public C removeCollection(String id) {
        return null;
    }

    @Override
    public C getCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        File collectionDir = new File(this.root, id);
        if (!collectionDir.exists() || !collectionDir.isDirectory()) {
            throw new ObjectNotFoundException("Unable to retrieve collection");
        }
        return this.newCollection(id);
    }

    @Override
    public List<C> getCollections() {
        return null;
    }
}

