/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.local;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import net.fortuna.ical4j.connector.CalendarCollection;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.MediaType;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.local.AbstractLocalObjectCollection;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.Calendars;

public class LocalCalendarCollection
extends AbstractLocalObjectCollection<Calendar>
implements CalendarCollection {
    private static final MediaType[] SUPPORTED_MEDIA_TYPES = new MediaType[1];

    public LocalCalendarCollection(File root) {
        super(root);
    }

    @Override
    public MediaType[] getSupportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    @Override
    public long getMaxResourceSize() {
        return 0L;
    }

    @Override
    public String getMinDateTime() {
        return null;
    }

    @Override
    public String getMaxDateTime() {
        return null;
    }

    @Override
    public Integer getMaxInstances() {
        return null;
    }

    @Override
    public Integer getMaxAttendeesPerInstance() {
        return null;
    }

    @Override
    public void addCalendar(Calendar calendar) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = Calendars.getUid((Calendar)calendar);
        if (uid == null) {
            throw new ConstraintViolationException("A valid UID was not found.");
        }
        try {
            Calendar existing = this.getCalendar(uid.getValue());
            throw new ObjectStoreException("Calendar already exists");
        }
        catch (ObjectNotFoundException existing) {
            try (FileWriter writer = new FileWriter(new File(this.getRoot(), uid.getValue() + ".ics"));){
                new CalendarOutputter(false).output(calendar, (Writer)writer);
            }
            catch (IOException e) {
                throw new ObjectStoreException("Error writing calendar file", e);
            }
            return;
        }
    }

    @Override
    public Calendar getCalendar(String uid) throws ObjectNotFoundException {
        try {
            return Calendars.load((String)new File(this.getRoot(), uid + ".ics").getAbsolutePath());
        }
        catch (IOException | ParserException e) {
            throw new ObjectNotFoundException(String.format("Calendar not found: %s", uid), e);
        }
    }

    @Override
    public Calendar removeCalendar(String uid) throws FailedOperationException, ObjectNotFoundException {
        Calendar calendar = this.getCalendar(uid);
        if (!new File(this.getRoot(), uid + ".ics").delete()) {
            throw new FailedOperationException("Unable to delete calendar: " + uid);
        }
        return calendar;
    }

    @Override
    public void merge(Calendar calendar) {
    }

    @Override
    public Calendar export() {
        return null;
    }

    public Calendar[] getComponents() throws ObjectStoreException {
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        File[] componentFiles = this.getRoot().listFiles(pathname -> !pathname.isDirectory() && pathname.getName().endsWith(".ics"));
        if (componentFiles != null) {
            try {
                for (File file : componentFiles) {
                    calendars.add(Calendars.load((String)file.getAbsolutePath()));
                }
            }
            catch (IOException | ParserException e) {
                throw new ObjectStoreException(e);
            }
        }
        return calendars.toArray(new Calendar[0]);
    }

    static {
        LocalCalendarCollection.SUPPORTED_MEDIA_TYPES[0] = MediaType.ICALENDAR_2_0;
    }
}

