/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import net.fortuna.ical4j.connector.CardCollection;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.MediaType;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.local.AbstractLocalObjectCollection;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilder;
import net.fortuna.ical4j.vcard.VCardOutputter;
import net.fortuna.ical4j.vcard.property.Uid;

public class LocalCardCollection
extends AbstractLocalObjectCollection<VCard>
implements CardCollection {
    private static final MediaType[] SUPPORTED_MEDIA_TYPES = new MediaType[1];

    public LocalCardCollection(File root) {
        super(root);
    }

    @Override
    public void addCard(VCard card) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = (Uid)card.getProperty(Property.Id.UID);
        if (uid == null) {
            throw new ConstraintViolationException("A valid UID was not found.");
        }
        try {
            VCard existing = this.getCard(uid.getValue());
            throw new ObjectStoreException("Card already exists");
        }
        catch (ObjectNotFoundException existing) {
            try (FileWriter writer = new FileWriter(new File(this.getRoot(), uid.getValue() + ".vcf"));){
                new VCardOutputter(false).output(card, (Writer)writer);
            }
            catch (IOException e) {
                throw new ObjectStoreException("Error writing card file", e);
            }
            return;
        }
    }

    public VCard getCard(String uid) throws ObjectNotFoundException {
        try {
            return new VCardBuilder((InputStream)new FileInputStream(new File(this.getRoot(), uid + ".vcf"))).build();
        }
        catch (IOException | ParserException e) {
            throw new ObjectNotFoundException(String.format("Card not found: %s", uid), e);
        }
    }

    @Override
    public VCard removeCard(String uid) throws ObjectNotFoundException, FailedOperationException {
        VCard card = this.getCard(uid);
        if (!new File(this.getRoot(), uid + ".vcf").delete()) {
            throw new FailedOperationException("Unable to delete card: " + uid);
        }
        return card;
    }

    public VCard[] getComponents() throws ObjectStoreException {
        ArrayList<VCard> cards = new ArrayList<VCard>();
        File[] componentFiles = this.getRoot().listFiles(pathname -> !pathname.isDirectory() && pathname.getName().endsWith(".vcf"));
        if (componentFiles != null) {
            try {
                for (File file : componentFiles) {
                    VCardBuilder builder = new VCardBuilder((InputStream)new FileInputStream(file));
                    cards.add(builder.build());
                }
            }
            catch (IOException | ParserException e) {
                throw new ObjectStoreException(e);
            }
        }
        return cards.toArray(new VCard[0]);
    }

    static {
        LocalCardCollection.SUPPORTED_MEDIA_TYPES[0] = MediaType.VCARD_4_0;
    }
}

