/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.extensions.property;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.property.ImmutableProperty;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.transform.recurrence.Frequency;
import org.threeten.extra.Days;
import org.threeten.extra.Hours;
import org.threeten.extra.Minutes;
import org.threeten.extra.Months;
import org.threeten.extra.Seconds;
import org.threeten.extra.Weeks;
import org.threeten.extra.Years;

public class Repeats<T extends Temporal>
extends RRule<T>
implements ImmutableProperty {
    public static final Repeats<LocalDate> YEARLY = new Repeats(Years.ONE);
    public static final Repeats<LocalDate> HALF_YEARLY = new Repeats(Months.of((int)6));
    public static final Repeats<LocalDate> QUARTERLY = new Repeats(Months.of((int)3));
    public static final Repeats<LocalDate> MONTHLY = new Repeats(Months.ONE);
    public static final Repeats<LocalDate> FORTNIGHTLY = new Repeats(Weeks.of((int)2));
    public static final Repeats<LocalDate> WEEKLY = new Repeats(Weeks.ONE);
    public static final Repeats<LocalDate> DAILY = new Repeats(Days.ONE);
    public static final Repeats<LocalDate> TWICE_DAILY = new Repeats(Hours.of((int)12));
    public static final Repeats<LocalDate> HOURLY = new Repeats(Hours.of((int)1));
    public static final Repeats<LocalDate> MINUTELY = new Repeats(Minutes.of((int)1));
    public static final Repeats<LocalDate> SECONDLY = new Repeats(Seconds.of((int)1));
    public static final Repeats<LocalDate> WEEKDAYS = new Repeats(Weeks.ONE).on(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    public static final Repeats<LocalDate> WEEKENDS = new Repeats(Weeks.ONE).on(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);

    public Repeats(Years interval) {
        this(new Recur.Builder().frequency(Frequency.YEARLY).interval(Integer.valueOf(interval.getAmount())).build());
    }

    public Repeats(Months interval) {
        this(new Recur.Builder().frequency(Frequency.MONTHLY).interval(Integer.valueOf(interval.getAmount())).build());
    }

    public Repeats(Weeks interval) {
        this(new Recur.Builder().frequency(Frequency.WEEKLY).interval(Integer.valueOf(interval.getAmount())).build());
    }

    public Repeats(Days interval) {
        this(new Recur.Builder().frequency(Frequency.DAILY).interval(Integer.valueOf(interval.getAmount())).build());
    }

    public Repeats(Hours interval) {
        this(new Recur.Builder().frequency(Frequency.HOURLY).interval(Integer.valueOf(interval.getAmount())).build());
    }

    public Repeats(Minutes interval) {
        this(new Recur.Builder().frequency(Frequency.MINUTELY).interval(Integer.valueOf(interval.getAmount())).build());
    }

    public Repeats(Seconds interval) {
        this(new Recur.Builder().frequency(Frequency.SECONDLY).interval(Integer.valueOf(interval.getAmount())).build());
    }

    private Repeats(Recur<?> recur) {
        this.setRecur(recur);
    }

    public <P extends Property> P add(Parameter parameter) {
        return (P)super.add(parameter);
    }

    public <P extends Property> P remove(Parameter parameter) {
        return (P)super.remove(parameter);
    }

    public <P extends Property> P removeAll(String ... parameterName) {
        return (P)super.removeAll(parameterName);
    }

    public <P extends Property> P replace(Parameter parameter) {
        return (P)super.replace(parameter);
    }

    public Repeats<T> on(DayOfWeek ... day) {
        return new Repeats<T>(new Recur.Builder(this.getRecur()).dayList(Arrays.stream(day).map(WeekDay::getWeekDay).collect(Collectors.toList())).build());
    }

    public Repeats<T> on(Integer ... dayOfMonth) {
        return new Repeats<T>(new Recur.Builder(this.getRecur()).monthDayList(Arrays.asList(dayOfMonth)).build());
    }

    public Repeats<T> on(Month ... month) {
        return new Repeats<T>(new Recur.Builder(this.getRecur()).monthList(Arrays.stream(month).map(m -> net.fortuna.ical4j.model.Month.valueOf((int)m.getValue())).collect(Collectors.toList())).build());
    }

    public Repeats<T> until(T endDate) {
        return new Repeats<T>(new Recur.Builder(this.getRecur()).until(endDate).build());
    }

    public Repeats<T> times(int count) {
        return new Repeats<T>(new Recur.Builder(this.getRecur()).count(Integer.valueOf(count)).build());
    }
}

