/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.extensions.strategy.vevent;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.extensions.model.concept.EventType;
import net.fortuna.ical4j.extensions.model.property.Repeats;
import net.fortuna.ical4j.extensions.strategy.vevent.VEventPropertyModifiers;
import net.fortuna.ical4j.model.ChangeManagementPropertyModifiers;
import net.fortuna.ical4j.model.DateTimePropertyModifiers;
import net.fortuna.ical4j.model.DescriptivePropertyModifiers;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.RecurrencePropertyModifiers;
import net.fortuna.ical4j.model.RelationshipPropertyModifiers;
import net.fortuna.ical4j.model.component.Participant;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VLocation;
import net.fortuna.ical4j.model.component.VResource;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.vcard.VCard;

public class Meeting {
    private ZonedDateTime start;
    private TemporalAmount duration;
    private VCard organizer;
    private Uid uid;
    private String summary;
    private String description;
    private Participant chair;
    private final List<Participant> required = new ArrayList<Participant>();
    private final List<Participant> optional = new ArrayList<Participant>();
    private Repeats<ZonedDateTime> repeats;
    private VLocation location;
    private List<VAlarm> notifications = new ArrayList<VAlarm>();
    private VToDo agenda;
    private VResource conference;
    private VResource recording;
    private VResource transcript;

    public Meeting organizer(VCard card) {
        this.organizer = card;
        return this;
    }

    public Meeting start(ZonedDateTime start) {
        this.start = start;
        return this;
    }

    public Meeting duration(TemporalAmount duration) {
        this.duration = duration;
        return this;
    }

    public Meeting required(Participant participant) {
        this.required.add(participant);
        return this;
    }

    public Meeting optional(Participant participant) {
        this.optional.add(participant);
        return this;
    }

    public Meeting chair(Participant participant) {
        this.chair = participant;
        return this;
    }

    public Meeting repeats(Repeats<ZonedDateTime> repeats) {
        this.repeats = repeats;
        return this;
    }

    public Meeting location(VLocation location) {
        this.location = location;
        return this;
    }

    public Meeting notification(VAlarm notification) {
        this.notifications.add(notification);
        return this;
    }

    public Meeting agenda(VToDo agenda) {
        this.agenda = agenda;
        return this;
    }

    public VEvent apply(VEvent vEvent) {
        vEvent.with(ChangeManagementPropertyModifiers.DTSTAMP, (Object)Instant.now());
        vEvent.replace((Property)EventType.MEETING);
        vEvent.with(RelationshipPropertyModifiers.UID, (Object)this.uid);
        vEvent.with(RecurrencePropertyModifiers.RRULE, this.repeats);
        vEvent.with(DescriptivePropertyModifiers.SUMMARY, (Object)this.summary);
        vEvent.with(DateTimePropertyModifiers.DTSTART, (Object)this.start);
        vEvent.with(DateTimePropertyModifiers.DURATION, (Object)this.duration);
        vEvent.with(VEventPropertyModifiers.ORGANIZER, (Object)this.organizer);
        vEvent.with(VEventPropertyModifiers.CHAIR, (Object)this.chair);
        this.required.forEach(p -> vEvent.with(VEventPropertyModifiers.REQUIRED_ATTENDEE, p));
        this.optional.forEach(p -> vEvent.with(VEventPropertyModifiers.OPTIONAL_ATTENDEE, p));
        this.notifications.forEach(arg_0 -> ((VEvent)vEvent).add(arg_0));
        return vEvent;
    }
}

