/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.vcard.AbstractFactory;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.parameter.Encoding;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.parameter.Value;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Photo
extends Property {
    private static final long serialVersionUID = 5927040228596008262L;
    private final Log log = LogFactory.getLog(Photo.class);
    private URI uri;
    private byte[] binary;

    public Photo(URI uri) {
        super(Property.Id.PHOTO);
        this.uri = uri;
        this.getParameters().add(Value.URI);
    }

    public Photo(byte[] binary) {
        this(binary, null);
    }

    public Photo(byte[] binary, Type contentType) {
        super(Property.Id.PHOTO);
        this.binary = binary;
        this.getParameters().add(Encoding.B);
        if (contentType != null) {
            this.getParameters().add(contentType);
        }
    }

    public Photo(List<Parameter> params, String value) throws URISyntaxException, DecoderException {
        super(Property.Id.PHOTO, params);
        Object valueParameter = this.getParameter(Parameter.Id.VALUE);
        if (Value.URI.equals(valueParameter) || valueParameter != null && CompatibilityHints.isHintEnabled((String)"ical4j.parsing.relaxed") && "URL".equalsIgnoreCase(((Parameter)valueParameter).getValue())) {
            this.uri = new URI(value);
        } else {
            Base64 decoder = new Base64();
            this.binary = decoder.decode(value.getBytes());
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    @Override
    public String getValue() {
        String stringValue = null;
        if (this.uri != null) {
            stringValue = Strings.valueOf((Object)this.uri);
        } else if (this.binary != null) {
            try {
                Base64 encoder = new Base64();
                stringValue = new String(encoder.encode(this.binary));
            }
            catch (EncoderException ee) {
                this.log.error((Object)"Error encoding binary data", (Throwable)ee);
            }
        }
        return stringValue;
    }

    @Override
    public void validate() throws ValidationException {
        this.assertOneOrLess(Parameter.Id.VALUE);
    }

    public static class Factory
    extends AbstractFactory
    implements PropertyFactory<Photo> {
        public Factory() {
            super(Property.Id.PHOTO.toString());
        }

        @Override
        public Photo createProperty(List<Parameter> params, String value) throws URISyntaxException, DecoderException {
            return new Photo(params, value);
        }

        @Override
        public Photo createProperty(Group group, List<Parameter> params, String value) {
            return null;
        }
    }
}

