/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard;

import java.text.MessageFormat;
import java.util.Optional;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.parameter.Value;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class GroupProperty
extends Property {
    private static final long serialVersionUID = 7813173744145071469L;
    protected static final String ILLEGAL_PARAMETER_MESSAGE = "Illegal parameter [{0}]";
    private static final String ILLEGAL_PARAMETER_COUNT_MESSAGE = "Parameter [{0}] exceeds allowable count";
    private final Group group;

    public GroupProperty(String propertyName) {
        this(null, propertyName);
    }

    public GroupProperty(Group group, String propertyName) {
        this(group, propertyName, new ParameterList());
    }

    public GroupProperty(String propertyName, ParameterList parameters) {
        this(null, propertyName, parameters);
    }

    public GroupProperty(Group group, String propertyName, ParameterList parameters) {
        super(propertyName, parameters);
        this.group = group;
    }

    public GroupProperty(PropertyName id) {
        this(null, id);
    }

    public GroupProperty(Group group, PropertyName id) {
        this(group, id, new ParameterList());
    }

    protected GroupProperty(PropertyName id, ParameterList parameters) {
        this(null, id, parameters);
    }

    protected GroupProperty(Group group, PropertyName id, ParameterList parameters) {
        super(id.toString(), parameters);
        this.group = group;
    }

    public final Group getGroup() {
        return this.group;
    }

    @Deprecated
    public final PropertyName getId() {
        return PropertyName.valueOf(this.getName());
    }

    public <P extends Parameter> Optional<P> getParameter(ParameterName name) {
        return this.getParameter(name.toString());
    }

    protected final void assertParametersEmpty() throws ValidationException {
        if (!this.getParameters(new String[0]).isEmpty()) {
            throw new ValidationException("No parameters allowed for property: " + this.getName());
        }
    }

    protected final void assertTextParameter(Parameter param) throws ValidationException {
        if (!(Value.TEXT.equals(param) || ParameterName.LANGUAGE.toString().equals(param.getName()) || ParameterName.EXTENDED.toString().equals(param.getName()))) {
            throw new ValidationException(MessageFormat.format(ILLEGAL_PARAMETER_MESSAGE, param.getName()));
        }
    }

    protected final void assertTypeParameter(Parameter param) throws ValidationException {
        if (!ParameterName.TYPE.toString().equals(param.getName())) {
            throw new ValidationException(MessageFormat.format(ILLEGAL_PARAMETER_MESSAGE, param.getName()));
        }
    }

    protected final void assertPidParameter(Parameter param) throws ValidationException {
        if (!ParameterName.PID.toString().equals(param.getName())) {
            throw new ValidationException(MessageFormat.format(ILLEGAL_PARAMETER_MESSAGE, param.getName()));
        }
    }

    protected final void assertPrefParameter(Parameter param) throws ValidationException {
        if (!ParameterName.PREF.toString().equals(param.getName())) {
            throw new ValidationException(MessageFormat.format(ILLEGAL_PARAMETER_MESSAGE, param.getName()));
        }
    }

    protected final void assertOneOrLess(ParameterName paramId) throws ValidationException {
        if (this.getParameters(new String[]{paramId.toString()}).size() > 1) {
            throw new ValidationException(MessageFormat.format(ILLEGAL_PARAMETER_COUNT_MESSAGE, new Object[]{paramId}));
        }
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof GroupProperty) {
            GroupProperty p = (GroupProperty)((Object)arg0);
            return this.getName().equals(p.getName()) && new EqualsBuilder().append((Object)this.group, (Object)p.getGroup()).append((Object)this.getValue(), (Object)p.getValue()).append((Object)this.getParameterList(), (Object)p.getParameterList()).isEquals();
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.group).append((Object)this.getName().toUpperCase()).append((Object)this.getValue()).append((Object)this.getParameterList()).toHashCode();
    }

    public final String toString() {
        if (this.group != null) {
            return this.group.toString() + '.' + super.toString();
        }
        return super.toString();
    }
}

