/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard;

import java.io.Serializable;
import java.util.List;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyContainer;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.property.immutable.ImmutableKind;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class VCard
implements Serializable,
PropertyContainer {
    private static final long serialVersionUID = -4784034340843199392L;
    private PropertyList properties;

    public VCard() {
        this(new PropertyList());
    }

    public VCard(PropertyList properties) {
        this.properties = properties;
    }

    public PropertyList getPropertyList() {
        return this.properties;
    }

    public void setPropertyList(PropertyList properties) {
        this.properties = properties;
    }

    public ValidationResult validate() throws ValidationException {
        ValidationResult result = new ValidationResult(new ValidationEntry[0]);
        this.assertOne(PropertyName.VERSION);
        this.assertOne(PropertyName.FN);
        boolean isKindGroup = false;
        List properties = this.getProperties(new String[]{PropertyName.KIND.toString()});
        if (properties.size() > 1) {
            result.getEntries().add(new ValidationEntry("Property [" + (Object)((Object)PropertyName.KIND) + "] must be specified zero or once", ValidationEntry.Severity.ERROR, "VCARD"));
        } else if (properties.size() == 1) {
            isKindGroup = ((Property)properties.iterator().next()).getValue().equals(ImmutableKind.GROUP.getValue());
        }
        for (Property property : this.getProperties(new String[0])) {
            if (!isKindGroup && property.getName().equals(PropertyName.MEMBER.toString())) {
                result.getEntries().add(new ValidationEntry("Property [" + (Object)((Object)PropertyName.MEMBER) + "] can only be specified if the KIND property value is \"group\".", ValidationEntry.Severity.ERROR, "VCARD"));
            }
            result.merge(property.validate());
        }
        return result;
    }

    private void assertOne(PropertyName propertyId) throws ValidationException {
        List properties = this.getProperties(new String[]{propertyId.toString()});
        if (properties.size() != 1) {
            throw new ValidationException("Property [" + (Object)((Object)propertyId) + "] must be specified once");
        }
    }

    public String toString() {
        return "BEGIN:VCARD\r\n" + this.properties + "END:VCARD" + "\r\n";
    }

    public boolean equals(Object obj) {
        if (obj instanceof VCard) {
            VCard card = (VCard)obj;
            return new EqualsBuilder().append((Object)this.getProperties(new String[0]), (Object)card.getProperties(new String[0])).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getProperties(new String[0])).toHashCode();
    }
}

