/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.ParameterCodec;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyCodec;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupRegistry;
import net.fortuna.ical4j.vcard.ParameterFactory;
import net.fortuna.ical4j.vcard.ParameterFactoryRegistry;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyFactoryRegistry;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilderContext;
import net.fortuna.ical4j.vcard.parameter.XParameter;
import net.fortuna.ical4j.vcard.property.XProperty;
import org.apache.commons.codec.DecoderException;

public final class VCardBuilder {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final Pattern VCARD_BEGIN = Pattern.compile("^BEGIN:VCARD$", 2);
    private static final Pattern RELAXED_VCARD_BEGIN = Pattern.compile("^BEGIN:VCARD\\s*$", 2);
    private static final Pattern VCARD_END = Pattern.compile("^END:VCARD$", 2);
    private static final Pattern RELAXED_VCARD_END = Pattern.compile("^END:VCARD\\s*$", 2);
    static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("^(([a-zA-Z-\\d]+\\.)?[a-zA-Z]+(?=[;:]))|(([a-zA-Z-\\d]+\\.)?[Xx]-[a-zA-Z-]+(?=[;:]))");
    private static final Pattern PROPERTY_VALUE_PATTERN = Pattern.compile("(?<=[:]).*$");
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("(?<=[;])[^:]*(?=[:])");
    private static final int BUFFER_SIZE = 1024;
    private final BufferedReader reader;
    private final GroupRegistry groupRegistry;
    private final VCardBuilderContext vCardBuilderContext;
    private final boolean relaxedParsing;

    public VCardBuilder(InputStream in) {
        this(new InputStreamReader(in, DEFAULT_CHARSET));
    }

    public VCardBuilder(Reader in) {
        this(in, new GroupRegistry(), new VCardBuilderContext());
    }

    @Deprecated
    public VCardBuilder(Reader in, GroupRegistry registry, PropertyFactoryRegistry propertyFactoryRegistry, ParameterFactoryRegistry parameterFactoryRegistry) {
        this(in, registry, new VCardBuilderContext());
    }

    public VCardBuilder(Reader in, GroupRegistry registry, VCardBuilderContext vCardBuilderContext) {
        this.reader = new BufferedReader((Reader)new UnfoldingReader(in, 1024), 1024);
        this.groupRegistry = registry;
        this.vCardBuilderContext = vCardBuilderContext;
        this.relaxedParsing = CompatibilityHints.isHintEnabled((String)"ical4j.parsing.relaxed");
    }

    public VCard build() throws IOException, ParserException {
        return this.build(true);
    }

    public List<VCard> buildAll() throws IOException, ParserException {
        VCard card;
        ArrayList<VCard> cards = new ArrayList<VCard>();
        while ((card = this.build(false)) != null) {
            cards.add(card);
        }
        return Collections.unmodifiableList(cards);
    }

    private VCard build(boolean single) throws IOException, ParserException {
        VCard vcard = null;
        String line = null;
        String lastLine = null;
        int nonBlankLineNo = 0;
        int totalLineNo = 0;
        boolean end = false;
        Pattern beginPattern = null;
        Pattern endPattern = null;
        if (this.relaxedParsing) {
            beginPattern = RELAXED_VCARD_BEGIN;
            endPattern = RELAXED_VCARD_END;
        } else {
            beginPattern = VCARD_BEGIN;
            endPattern = VCARD_END;
        }
        while ((single || !end) && (line = this.reader.readLine()) != null) {
            ++totalLineNo;
            if (line.trim().length() == 0) continue;
            if (++nonBlankLineNo == 1) {
                if (!beginPattern.matcher(line).matches()) {
                    throw new ParserException(nonBlankLineNo);
                }
                vcard = new VCard();
            } else if (!endPattern.matcher(line).matches()) {
                Property property;
                try {
                    property = this.parseProperty(line);
                }
                catch (URISyntaxException | ParseException | DecoderException e) {
                    throw new ParserException("Error parsing line", totalLineNo, e);
                }
                if (property != null) {
                    vcard.add(property);
                }
            } else if (endPattern.matcher(line).matches()) {
                end = true;
            }
            if (line.trim().length() <= 0) continue;
            lastLine = line;
        }
        if (single && (nonBlankLineNo <= 1 || !endPattern.matcher(lastLine).matches())) {
            throw new ParserException(totalLineNo);
        }
        return vcard;
    }

    private Property parseProperty(String line) throws URISyntaxException, ParseException, DecoderException {
        XProperty property = null;
        Matcher matcher = PROPERTY_NAME_PATTERN.matcher(line);
        if (matcher.find()) {
            Optional<PropertyFactory> factory;
            Group group = null;
            String propertyName = matcher.group().toUpperCase();
            if (propertyName.indexOf(46) >= 0) {
                String[] groupProperty = propertyName.split("\\.");
                group = this.groupRegistry.getGroup(groupProperty[0]);
                factory = this.vCardBuilderContext.getPropertyFactorySupplier().get().stream().filter(f -> f.supports(groupProperty[1])).findFirst();
            } else {
                factory = this.vCardBuilderContext.getPropertyFactorySupplier().get().stream().filter(f -> f.supports(propertyName)).findFirst();
            }
            matcher = PROPERTY_VALUE_PATTERN.matcher(line);
            if (matcher.find()) {
                String decodedValue;
                String propertyValue = matcher.group(0);
                try {
                    decodedValue = PropertyCodec.INSTANCE.decode(propertyValue);
                }
                catch (DecoderException e) {
                    decodedValue = propertyValue;
                }
                ParameterList params = this.parseParameters(line);
                if (factory.isPresent()) {
                    if (group != null) {
                        return factory.get().createProperty(group, params, decodedValue);
                    }
                    return factory.get().createProperty(params, decodedValue);
                }
                if (this.isExtendedName(propertyName)) {
                    property = group != null ? new XProperty(group, propertyName, params, decodedValue) : new XProperty(propertyName, params, decodedValue);
                }
            }
        }
        return property;
    }

    private boolean isExtendedName(String name) {
        return name.startsWith("X-");
    }

    private ParameterList parseParameters(String line) throws URISyntaxException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Matcher matcher = PARAMETERS_PATTERN.matcher(line);
        if (matcher.find()) {
            String[] params;
            for (String param : params = matcher.group().split(";")) {
                String decodedValue;
                String[] vals = param.split("=");
                List<ParameterFactory<?>> factories = this.vCardBuilderContext.getParameterFactorySupplier().get();
                Optional<ParameterFactory> factory = factories.stream().filter(f -> f.supports(vals[0])).findFirst();
                if (factory.isPresent()) {
                    if (vals.length > 1) {
                        try {
                            decodedValue = ParameterCodec.INSTANCE.decode(vals[1]);
                        }
                        catch (DecoderException e) {
                            decodedValue = vals[1];
                        }
                        parameters.add(factory.get().createParameter(decodedValue));
                        continue;
                    }
                    parameters.add(factory.get().createParameter());
                    continue;
                }
                if (!this.isExtendedName(vals[0])) continue;
                if (vals.length > 1) {
                    try {
                        decodedValue = ParameterCodec.INSTANCE.decode(vals[1]);
                    }
                    catch (DecoderException e) {
                        decodedValue = vals[1];
                    }
                    parameters.add((Object)new XParameter(vals[0], decodedValue));
                    continue;
                }
                parameters.add((Object)new XParameter(vals[0], null));
            }
        }
        return new ParameterList(parameters);
    }
}

