/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.vcard.ParameterFactory;
import net.fortuna.ical4j.vcard.ParameterName;

public final class MediaType
extends Parameter {
    private static final long serialVersionUID = -3644362129355908795L;
    public static final MediaType HOME = new MediaType("home");
    public static final MediaType WORK = new MediaType("work");
    public static final MediaType PREF = new MediaType("pref");
    private final String[] types;

    public MediaType(String value) {
        super(ParameterName.TYPE.toString());
        this.types = value.split(",");
    }

    public MediaType(String ... types) {
        super(ParameterName.TYPE.toString());
        this.types = types;
    }

    public MediaType(MediaType ... types) {
        super(ParameterName.TYPE.toString());
        ArrayList<String> typeList = new ArrayList<String>();
        for (MediaType type : types) {
            typeList.addAll(Arrays.asList(type.getTypes()));
        }
        this.types = typeList.toArray(new String[typeList.size()]);
    }

    public String[] getTypes() {
        return this.types;
    }

    public String getValue() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.types.length; ++i) {
            b.append(this.types[i]);
            if (i >= this.types.length - 1) continue;
            b.append(',');
        }
        return b.toString();
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<MediaType> {
        public Factory() {
            super(new String[]{ParameterName.TYPE.toString()});
        }

        public MediaType createParameter(String value) {
            MediaType parameter = null;
            parameter = HOME.getValue().equals(value) ? HOME : (PREF.getValue().equals(value) ? PREF : (WORK.getValue().equals(value) ? WORK : new MediaType(value)));
            return parameter;
        }
    }
}

