/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.parameter.Value;

@Deprecated
public class Agent
extends GroupProperty
implements Encodable {
    private static final long serialVersionUID = 2670466615841142934L;
    private URI uri;
    private String text;

    public Agent(URI uri) {
        super(PropertyName.AGENT);
        this.uri = uri;
    }

    public Agent(String text) {
        super(PropertyName.AGENT);
        this.text = text;
        this.add(Value.TEXT);
    }

    public Agent(ParameterList params, String value) {
        super(PropertyName.AGENT, params);
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE))) {
            this.text = value;
        } else {
            try {
                this.uri = new URI(value);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE))) {
            return this.text;
        }
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String aValue) {
        try {
            this.uri = new URI(aValue);
            this.text = null;
        }
        catch (URISyntaxException e) {
            this.text = aValue;
            this.uri = null;
        }
    }

    public ValidationResult validate() throws ValidationException {
        for (Parameter param : this.getParameters(new String[0])) {
            try {
                this.assertTextParameter(param);
            }
            catch (ValidationException ve) {
                this.assertPidParameter(param);
            }
        }
        return null;
    }

    protected PropertyFactory<Agent> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Agent> {
        public Factory() {
            super(new String[]{PropertyName.AGENT.toString()});
        }

        public Agent createProperty(ParameterList params, String value) {
            return new Agent(params, Strings.unescape((String)value));
        }

        @Override
        public Agent createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

