/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.text.ParseException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.parameter.Value;

public class BDay
extends GroupProperty
implements Encodable {
    private static final long serialVersionUID = 4298026868242865633L;
    private Date date;
    private String text;

    public BDay(Date date) {
        super(PropertyName.BDAY);
        this.date = date;
    }

    public BDay(String text) {
        super(PropertyName.BDAY);
        this.text = text;
        this.add(Value.TEXT);
    }

    public BDay(ParameterList params, String value) {
        super(PropertyName.BDAY, params);
        this.setValue(value);
    }

    public Date getDate() {
        return this.date;
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE))) {
            return this.text;
        }
        return Strings.valueOf((Object)this.date);
    }

    public void setValue(String value) {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE))) {
            this.text = value;
        } else {
            try {
                this.date = new Date(value);
            }
            catch (ParseException e) {
                try {
                    this.date = new DateTime(value);
                }
                catch (ParseException e2) {
                    try {
                        this.date = new Date(value, "yyyy'-'MM'-'dd");
                    }
                    catch (ParseException e3) {
                        try {
                            this.date = new DateTime(value, "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'", true);
                        }
                        catch (ParseException ex) {
                            throw new IllegalArgumentException(ex);
                        }
                    }
                }
            }
        }
    }

    public ValidationResult validate() throws ValidationException {
        this.assertOneOrLess(ParameterName.VALUE);
        if (this.getParameters(new String[0]).size() > 1) {
            throw new ValidationException("Illegal parameter count");
        }
        for (Parameter param : this.getParameters(new String[0])) {
            if (Value.TEXT.equals(param)) continue;
            throw new ValidationException("Illegal parameter [" + param.getName() + "]");
        }
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<BDay> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<BDay> {
        public Factory() {
            super(new String[]{PropertyName.BDAY.toString()});
        }

        public BDay createProperty(ParameterList params, String value) {
            return new BDay(params, Strings.unescape((String)value));
        }

        @Override
        public BDay createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

