/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.parameter.Type;

public class CalUri
extends GroupProperty {
    private static final long serialVersionUID = 4821378252642288695L;
    private URI uri;

    public CalUri(URI uri, Type ... types) {
        super(PropertyName.CALURI);
        this.uri = uri;
        for (Type type : types) {
            this.add(type);
        }
    }

    public CalUri(ParameterList params, String value) {
        super(PropertyName.CALURI);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String aValue) {
        try {
            this.uri = new URI(aValue);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<CalUri> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<CalUri> {
        public Factory() {
            super(new String[]{PropertyName.CALURI.toString()});
        }

        public CalUri createProperty(ParameterList params, String value) {
            return new CalUri(params, value);
        }

        @Override
        public CalUri createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

