/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.TextList;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;

public class Categories
extends GroupProperty {
    private static final long serialVersionUID = -3233034210546002366L;
    private TextList categories;

    public Categories(String ... categories) {
        super(PropertyName.CATEGORIES);
        if (categories.length == 0) {
            throw new IllegalArgumentException("Must specify at least category value");
        }
        this.categories = new TextList(categories);
    }

    public Categories(ParameterList params, String value) {
        super(PropertyName.CATEGORIES);
        this.categories = new TextList(value);
    }

    public TextList getCategories() {
        return this.categories;
    }

    public String getValue() {
        return this.categories.toString();
    }

    public void setValue(String aValue) {
        this.categories = new TextList(aValue);
    }

    public ValidationResult validate() throws ValidationException {
        for (Parameter param : this.getParameters(new String[0])) {
            try {
                this.assertTextParameter(param);
            }
            catch (ValidationException ve) {
                this.assertPidParameter(param);
            }
        }
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Categories> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Categories> {
        public Factory() {
            super(new String[]{PropertyName.CATEGORIES.toString()});
        }

        @Override
        public Categories createProperty() {
            return new Categories(new String[0]);
        }

        public Categories createProperty(ParameterList params, String value) {
            return new Categories(params, value);
        }

        @Override
        public Categories createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

