/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.math.BigDecimal;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;

public class Geo
extends GroupProperty {
    private static final long serialVersionUID = 1533383111522264554L;
    private static final String DELIMITER = ";";
    private BigDecimal latitude;
    private BigDecimal longitude;

    public Geo(BigDecimal latitude, BigDecimal longitude) {
        super(PropertyName.GEO);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Geo(ParameterList params, String value) {
        this(null, params, value);
    }

    public Geo(Group group, ParameterList params, String value) {
        super(group, PropertyName.GEO, params);
        this.setValue(value);
    }

    public String getValue() {
        return this.getLatitude() + DELIMITER + this.getLongitude();
    }

    public void setValue(String value) {
        String[] components = null;
        components = CompatibilityHints.isHintEnabled((String)"ical4j.parsing.relaxed") ? value.split("[;,]") : value.split(DELIMITER);
        this.latitude = new BigDecimal(components[0]);
        this.longitude = new BigDecimal(components[1]);
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public ValidationResult validate() throws ValidationException {
        this.assertParametersEmpty();
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Geo> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Geo> {
        public Factory() {
            super(new String[]{PropertyName.GEO.toString()});
        }

        public Geo createProperty(ParameterList params, String value) {
            return new Geo(params, value);
        }

        @Override
        public Geo createProperty(Group group, ParameterList params, String value) {
            return new Geo(group, params, value);
        }
    }
}

