/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.parameter.Encoding;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.parameter.Value;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Key
extends GroupProperty {
    private static final long serialVersionUID = -6645173064940148955L;
    private URI uri;
    private byte[] binary;
    private final Log log = LogFactory.getLog(Key.class);

    public Key(URI uri) {
        super(PropertyName.KEY);
        this.uri = uri;
        this.add(Value.URI);
    }

    public Key(byte[] binary) {
        this(binary, null);
    }

    public Key(byte[] binary, Type contentType) {
        super(PropertyName.KEY);
        this.binary = binary;
        this.add(Encoding.B);
        if (contentType != null) {
            this.add(contentType);
        }
    }

    public Key(ParameterList params, String value) {
        this(null, params, value);
    }

    public Key(Group group, ParameterList params, String value) {
        super(group, PropertyName.KEY, params);
        this.setValue(value);
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public String getValue() {
        Optional valueParameter = this.getParameter(ParameterName.VALUE);
        String stringValue = null;
        if (valueParameter.isPresent() && "URL".equalsIgnoreCase(((Parameter)valueParameter.get()).getValue())) {
            stringValue = Strings.valueOf((Object)this.uri);
        } else if (this.binary != null) {
            try {
                Base64 encoder = new Base64();
                stringValue = new String(encoder.encode(this.binary));
            }
            catch (EncoderException ee) {
                this.log.error((Object)"Error encoding binary data", (Throwable)ee);
            }
        }
        return stringValue;
    }

    public void setValue(String value) {
        Optional valueParameter = this.getParameter(ParameterName.VALUE);
        if (valueParameter.isPresent() && "URL".equalsIgnoreCase(((Parameter)valueParameter.get()).getValue())) {
            try {
                this.uri = new URI(value);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Base64 decoder = new Base64();
        try {
            this.binary = decoder.decode(value.getBytes());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        for (Parameter param : this.getParameters(new String[0])) {
            this.assertPidParameter(param);
        }
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Key> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Key> {
        public Factory() {
            super(new String[]{PropertyName.KEY.toString()});
        }

        public Key createProperty(ParameterList params, String value) {
            return new Key(params, value);
        }

        @Override
        public Key createProperty(Group group, ParameterList params, String value) {
            return new Key(group, params, value);
        }
    }
}

