/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.util.Arrays;
import java.util.Locale;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;

public class Lang
extends GroupProperty {
    private static final long serialVersionUID = 1863658302945551760L;
    private Locale[] locales;

    public Lang(Locale ... locales) {
        super(PropertyName.LANG);
        if (locales.length == 0) {
            throw new IllegalArgumentException("Must have at least one locale");
        }
        this.locales = locales;
    }

    public Lang(ParameterList params, String value) {
        super(PropertyName.LANG, params);
        this.setValue(value);
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public String getValue() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.locales.length; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append(this.locales[i].getLanguage());
        }
        return b.toString();
    }

    public void setValue(String value) {
        this.locales = (Locale[])Arrays.stream(value.split(",")).map(Locale::new).toArray(Locale[]::new);
    }

    public ValidationResult validate() throws ValidationException {
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Lang> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Lang> {
        public Factory() {
            super(new String[]{PropertyName.LANG.toString()});
        }

        public Lang createProperty(ParameterList params, String value) {
            return new Lang(params, value);
        }

        @Override
        public Lang createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

