/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;

public class Member
extends GroupProperty {
    private static final long serialVersionUID = 6622845049765958916L;
    private URI uri;

    public Member(URI uri) {
        super(PropertyName.MEMBER);
        this.uri = uri;
    }

    public Member(ParameterList params, String value) {
        super(PropertyName.MEMBER, params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String value) {
        try {
            this.uri = new URI(value);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        for (Parameter param : this.getParameters(new String[0])) {
            this.assertPidParameter(param);
        }
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Member> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Member> {
        public Factory() {
            super(new String[]{PropertyName.MEMBER.toString()});
        }

        public Member createProperty(ParameterList params, String value) {
            return new Member(params, value);
        }

        @Override
        public Member createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

