/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class N
extends GroupProperty {
    private static final long serialVersionUID = 1117450875931318523L;
    private String familyName;
    private String givenName;
    private String[] additionalNames;
    private String[] prefixes;
    private String[] suffixes;

    public N(String familyName, String givenName, String[] additionalNames, String[] prefixes, String[] suffixes) {
        super(PropertyName.N);
        this.familyName = familyName;
        this.givenName = givenName;
        this.additionalNames = additionalNames;
        this.prefixes = prefixes;
        this.suffixes = suffixes;
    }

    public N(ParameterList params, String value) {
        super(PropertyName.N, params);
        this.setValue(value);
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String[] getAdditionalNames() {
        return this.additionalNames;
    }

    public String[] getPrefixes() {
        return this.prefixes;
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    public String getValue() {
        int i;
        StringBuilder b = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.familyName)) {
            b.append(this.familyName);
        }
        b.append(';');
        if (StringUtils.isNotEmpty((CharSequence)this.givenName)) {
            b.append(this.givenName);
        }
        b.append(';');
        if (!ArrayUtils.isEmpty((Object[])this.additionalNames)) {
            for (i = 0; i < this.additionalNames.length; ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(this.additionalNames[i]);
            }
        }
        b.append(';');
        if (!ArrayUtils.isEmpty((Object[])this.prefixes)) {
            for (i = 0; i < this.prefixes.length; ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(this.prefixes[i]);
            }
        }
        b.append(';');
        if (!ArrayUtils.isEmpty((Object[])this.suffixes)) {
            for (i = 0; i < this.suffixes.length; ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(this.suffixes[i]);
            }
        }
        return b.toString();
    }

    public void setValue(String value) {
        String[] names = value.split(";", -1);
        this.familyName = names[0];
        if (names.length >= 2) {
            this.givenName = names[1];
        }
        if (CompatibilityHints.isHintEnabled((String)"ical4j.parsing.relaxed")) {
            this.parseValueRelaxed(names);
        } else {
            this.parseValue(names);
        }
    }

    private void parseValueRelaxed(String[] names) {
        if (names.length >= 3) {
            this.additionalNames = names[2].split(",");
        }
        if (names.length >= 4) {
            this.prefixes = names[3].split(",");
        }
        if (names.length >= 5) {
            this.suffixes = names[4].split(",");
        }
    }

    private void parseValue(String[] names) {
        if (names.length > 2) {
            this.additionalNames = names[2].split(",");
        }
        if (names.length > 3) {
            this.prefixes = names[3].split(",");
        }
        if (names.length > 4) {
            this.suffixes = names[4].split(",");
        }
    }

    public ValidationResult validate() throws ValidationException {
        for (Parameter param : this.getParameters(new String[0])) {
            this.assertTextParameter(param);
        }
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<N> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<N> {
        public Factory() {
            super(new String[]{PropertyName.N.toString()});
        }

        public N createProperty(ParameterList params, String value) {
            return new N(params, value);
        }

        @Override
        public N createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

