/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;

public class Nickname
extends GroupProperty {
    private static final long serialVersionUID = 2512809288464680577L;
    private String[] names;

    public Nickname(String ... names) {
        super(PropertyName.NICKNAME);
        if (names.length == 0) {
            throw new IllegalArgumentException("Must specify at least one nickname");
        }
        this.names = names;
    }

    public Nickname(ParameterList params, String value) {
        super(PropertyName.NICKNAME, params);
        this.names = value.split(",");
    }

    public String[] getNames() {
        return this.names;
    }

    public String getValue() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append(this.names[i]);
        }
        return b.toString();
    }

    public void setValue(String value) {
        this.names = value.split(",");
    }

    public ValidationResult validate() throws ValidationException {
        for (Parameter param : this.getParameters(new String[0])) {
            try {
                this.assertTextParameter(param);
            }
            catch (ValidationException ve) {
                this.assertPidParameter(param);
            }
        }
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Nickname> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Nickname> {
        public Factory() {
            super(new String[]{PropertyName.NICKNAME.toString()});
        }

        public Nickname createProperty(ParameterList params, String value) {
            return new Nickname(params, value);
        }

        @Override
        public Nickname createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

