/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.parameter.Encoding;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.parameter.Value;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Photo
extends GroupProperty {
    private static final long serialVersionUID = 5927040228596008262L;
    private final Log log = LogFactory.getLog(Photo.class);
    private URI uri;
    private byte[] binary;

    public Photo(URI uri) {
        super(PropertyName.PHOTO);
        this.uri = uri;
        this.add(Value.URI);
    }

    public Photo(byte[] binary) {
        this(binary, null);
    }

    public Photo(byte[] binary, Type contentType) {
        super(PropertyName.PHOTO);
        this.binary = binary;
        this.add(Encoding.B);
        if (contentType != null) {
            this.add(contentType);
        }
    }

    public Photo(ParameterList params, String value) {
        super(PropertyName.PHOTO, params);
        this.setValue(value);
    }

    public Photo(Group group, ParameterList parameters, String value) {
        super(group, PropertyName.PHOTO, parameters);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public String getValue() {
        String stringValue = null;
        if (this.uri != null) {
            stringValue = Strings.valueOf((Object)this.uri);
        } else if (this.binary != null) {
            try {
                Base64 encoder = new Base64();
                stringValue = new String(encoder.encode(this.binary));
            }
            catch (EncoderException ee) {
                this.log.error((Object)"Error encoding binary data", (Throwable)ee);
            }
        }
        return stringValue;
    }

    public void setValue(String value) {
        if (Optional.of(Value.URI).equals(this.getParameter(ParameterName.VALUE)) || CompatibilityHints.isHintEnabled((String)"ical4j.parsing.relaxed") && Optional.of(Value.URL).equals(this.getParameter(ParameterName.VALUE))) {
            try {
                this.uri = new URI(value);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Base64 decoder = new Base64();
        try {
            this.binary = decoder.decode(value.getBytes());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        this.assertOneOrLess(ParameterName.VALUE);
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Photo> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Photo> {
        public Factory() {
            super(new String[]{PropertyName.PHOTO.toString()});
        }

        public Photo createProperty(ParameterList params, String value) {
            return new Photo(params, value);
        }

        @Override
        public Photo createProperty(Group group, ParameterList params, String value) {
            return new Photo(group, params, value);
        }
    }
}

