/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.parameter.Value;

public class Related
extends GroupProperty {
    private static final long serialVersionUID = -3319959600372278036L;
    private URI uri;
    private String text;

    public Related(String text, Type ... types) {
        super(PropertyName.RELATED);
        this.text = text;
        this.add(Value.TEXT);
        Arrays.stream(types).forEach(arg_0 -> ((Related)this).add(arg_0));
    }

    public Related(URI uri, Type ... types) {
        super(PropertyName.RELATED);
        this.uri = uri;
        Arrays.stream(types).forEach(arg_0 -> ((Related)this).add(arg_0));
    }

    public Related(ParameterList params, String value) {
        super(PropertyName.RELATED, params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE))) {
            return this.text;
        }
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String value) {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE))) {
            this.text = value;
        } else {
            try {
                this.uri = new URI(value);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public ValidationResult validate() throws ValidationException {
        for (Parameter param : this.getParameters(new String[0])) {
            try {
                this.assertTypeParameter(param);
            }
            catch (ValidationException ve) {
                this.assertPidParameter(param);
            }
        }
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Related> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Related> {
        public Factory() {
            super(new String[]{PropertyName.RELATED.toString()});
        }

        public Related createProperty(ParameterList params, String value) {
            return new Related(params, value);
        }

        @Override
        public Related createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

