/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.text.ParseException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;

public class Revision
extends GroupProperty {
    private static final long serialVersionUID = -1342640230576672871L;
    private Date date;

    public Revision(Date date) {
        super(PropertyName.REV);
        this.date = date;
    }

    public Revision(ParameterList params, String value) {
        super(PropertyName.REV, params);
        this.setValue(value);
    }

    public Date getDate() {
        return this.date;
    }

    public String getValue() {
        return Strings.valueOf((Object)this.date);
    }

    public void setValue(String value) {
        try {
            this.date = new DateTime(value);
        }
        catch (ParseException e) {
            try {
                this.date = new Date(value);
            }
            catch (ParseException e2) {
                try {
                    this.date = new DateTime(value, "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'", true);
                }
                catch (ParseException e3) {
                    try {
                        this.date = new Date(value, "yyyy'-'MM'-'dd");
                    }
                    catch (ParseException ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
        }
    }

    public ValidationResult validate() throws ValidationException {
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Revision> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Revision> {
        public Factory() {
            super(new String[]{PropertyName.REV.toString()});
        }

        public Revision createProperty(ParameterList params, String value) {
            return new Revision(params, value);
        }

        @Override
        public Revision createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

