/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;

public class Uid
extends GroupProperty {
    private static final long serialVersionUID = -7120539613021006347L;
    private URI uri;

    public Uid(URI uri) {
        super(PropertyName.UID);
        this.uri = uri;
    }

    public Uid(ParameterList params, String value) {
        super(PropertyName.UID, params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String value) {
        try {
            this.uri = new URI(value);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        this.assertParametersEmpty();
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Uid> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Uid> {
        public Factory() {
            super(new String[]{PropertyName.UID.toString()});
        }

        public Uid createProperty(ParameterList params, String value) {
            return new Uid(params, value);
        }

        @Override
        public Uid createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

