/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;

public class Url
extends GroupProperty {
    private static final long serialVersionUID = -6689531541656904891L;
    private URI uri;

    public Url(URI uri) {
        super(PropertyName.URL);
        this.uri = uri;
    }

    public Url(ParameterList params, String value) {
        super(PropertyName.URL, params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String value) {
        try {
            this.uri = new URI(value);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        for (Parameter param : this.getParameters(new String[0])) {
            this.assertPidParameter(param);
        }
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Url> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Url> {
        public Factory() {
            super(new String[]{PropertyName.URL.toString()});
        }

        public Url createProperty(ParameterList params, String value) {
            return new Url(params, value);
        }

        @Override
        public Url createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

