/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.vcard.ParameterFactory;
import net.fortuna.ical4j.vcard.ParameterName;

public final class Type
extends Parameter {
    private static final long serialVersionUID = -3644362129355908795L;
    public static final Type HOME = new Type("home");
    public static final Type WORK = new Type("work");
    @Deprecated
    public static final Type PREF = new Type("pref");
    private final String[] types;

    public Type(String value) {
        super(ParameterName.TYPE.toString());
        this.types = value.split(",");
    }

    public Type(String ... types) {
        super(ParameterName.TYPE.toString());
        this.types = types;
    }

    public Type(Type ... types) {
        super(ParameterName.TYPE.toString());
        ArrayList<String> typeList = new ArrayList<String>();
        for (Type type : types) {
            typeList.addAll(Arrays.asList(type.getTypes()));
        }
        this.types = typeList.toArray(new String[typeList.size()]);
    }

    public String[] getTypes() {
        return this.types;
    }

    public String getValue() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.types.length; ++i) {
            b.append(this.types[i]);
            if (i >= this.types.length - 1) continue;
            b.append(',');
        }
        return b.toString();
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Type> {
        public Factory() {
            super(new String[]{ParameterName.TYPE.toString()});
        }

        public Type createParameter(String value) {
            Type parameter = null;
            parameter = HOME.getValue().equals(value) ? HOME : (PREF.getValue().equals(value) ? PREF : (WORK.getValue().equals(value) ? WORK : new Type(value)));
            return parameter;
        }
    }
}

