/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Type;

public class FbUrl
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = 7406097765207265428L;
    private URI uri;

    public FbUrl(URI uri, Type ... types) {
        super(PropertyName.FBURL.toString());
        this.uri = uri;
        for (Type type : types) {
            this.add(type);
        }
    }

    public FbUrl(ParameterList params, String value) {
        super(PropertyName.FBURL.toString(), params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String aValue) {
        try {
            this.uri = new URI(aValue);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        return FBURL.validate((Object)this);
    }

    protected PropertyFactory<FbUrl> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<FbUrl> {
        public Factory() {
            super(new String[]{PropertyName.FBURL.toString()});
        }

        public FbUrl createProperty(ParameterList params, String value) {
            return new FbUrl(params, value);
        }

        @Override
        public FbUrl createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

