/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.property.immutable.ImmutableGender;

public class Gender
extends Property
implements PropertyValidatorSupport,
GroupProperty {
    private static final long serialVersionUID = -2739534182576803750L;
    public static final String MALE = "M";
    public static final String FEMALE = "F";
    public static final String OTHER = "O";
    public static final String NONE = "N";
    public static final String UNKNOWN = "U";
    private String sex;
    private String text;

    public Gender(String value) {
        super(PropertyName.GENDER.toString());
        String[] components = value.split(";");
        this.sex = components[0];
        if (components.length > 1) {
            this.text = components[1];
        }
    }

    public Gender(String sex, String text) {
        super(PropertyName.GENDER.toString());
        this.sex = sex;
        this.text = text;
    }

    private Gender(ParameterList params, String value) {
        super(PropertyName.GENDER.toString(), params);
        this.setValue(value);
    }

    public Gender(ParameterList params, String sex, String text) {
        super(PropertyName.GENDER.toString(), params);
        this.sex = sex;
        this.text = text;
    }

    @Deprecated
    public Gender(Group group, ParameterList parameters, String value) {
        this(parameters, value);
        this.setGroup(group);
    }

    public String getValue() {
        if (this.text != null && !this.text.isEmpty()) {
            return this.sex + ";" + this.text;
        }
        return this.sex;
    }

    public void setValue(String aValue) {
        String[] components = aValue.split(";");
        this.sex = components[0];
        if (components.length > 1) {
            this.text = components[1];
        }
    }

    public ValidationResult validate() throws ValidationException {
        return GENDER.validate((Object)this);
    }

    protected PropertyFactory<Gender> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Gender> {
        public Factory() {
            super(new String[]{PropertyName.GENDER.toString()});
        }

        public Gender createProperty(ParameterList params, String value) {
            if (params.getAll().isEmpty()) {
                if (ImmutableGender.FEMALE.getValue().equalsIgnoreCase(value)) {
                    return ImmutableGender.FEMALE;
                }
                if (ImmutableGender.MALE.getValue().equalsIgnoreCase(value)) {
                    return ImmutableGender.MALE;
                }
                if (ImmutableGender.OTHER.getValue().equalsIgnoreCase(value)) {
                    return ImmutableGender.OTHER;
                }
                if (ImmutableGender.NONE.getValue().equalsIgnoreCase(value)) {
                    return ImmutableGender.NONE;
                }
                if (ImmutableGender.UNKNOWN.getValue().equalsIgnoreCase(value)) {
                    return ImmutableGender.UNKNOWN;
                }
            }
            return new Gender(params, value);
        }

        @Override
        public Gender createProperty(Group group, ParameterList params, String value) {
            return new Gender(group, params, value);
        }
    }
}

