/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.property.immutable.ImmutableKind;

public class Kind
extends Property
implements PropertyValidatorSupport,
GroupProperty {
    private static final long serialVersionUID = -3114221975393833838L;
    private String value;

    public Kind(String value) {
        super(PropertyName.KIND.toString());
        this.value = value;
    }

    public Kind(ParameterList params, String value) {
        super(PropertyName.KIND.toString(), params);
        this.setValue(value);
    }

    @Deprecated
    public Kind(Group group, ParameterList parameters, String value) {
        this(parameters, value);
        this.setGroup(group);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public ValidationResult validate() throws ValidationException {
        return KIND.validate((Object)this);
    }

    protected PropertyFactory<Kind> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Kind> {
        public Factory() {
            super(new String[]{PropertyName.KIND.toString()});
        }

        public Kind createProperty(ParameterList params, String value) {
            if (params.getAll().isEmpty()) {
                if (ImmutableKind.GROUP.getValue().equalsIgnoreCase(value)) {
                    return ImmutableKind.GROUP;
                }
                if (ImmutableKind.INDIVIDUAL.getValue().equalsIgnoreCase(value)) {
                    return ImmutableKind.INDIVIDUAL;
                }
                if (ImmutableKind.ORG.getValue().equalsIgnoreCase(value)) {
                    return ImmutableKind.ORG;
                }
                if (ImmutableKind.LOCATION.getValue().equalsIgnoreCase(value)) {
                    return ImmutableKind.LOCATION;
                }
                if (ImmutableKind.THING.getValue().equalsIgnoreCase(value)) {
                    return ImmutableKind.THING;
                }
            }
            return new Kind(params, value);
        }

        @Override
        public Kind createProperty(Group group, ParameterList params, String value) {
            return new Kind(group, params, value);
        }
    }
}

