/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;

public class Org
extends Property
implements PropertyValidatorSupport,
GroupProperty {
    private static final long serialVersionUID = -1435956318814896568L;
    private static final String VALUES_SPLIT_REGEX = "(?<!\\\\)(?>\\\\\\\\)*;";
    private String[] values;

    public Org(String ... value) {
        super(PropertyName.ORG.toString());
        if (value.length == 0) {
            throw new IllegalArgumentException("Must specify at least one organization");
        }
        this.values = value;
    }

    @Deprecated
    public Org(Group group, String ... value) {
        this(value);
        this.setGroup(group);
    }

    public Org(ParameterList params, String value) {
        super(PropertyName.ORG.toString(), params);
        this.values = value.split(VALUES_SPLIT_REGEX);
    }

    @Deprecated
    public Org(Group group, ParameterList params, String value) {
        this(params, value);
        this.setGroup(group);
    }

    public String[] getValues() {
        return this.values;
    }

    public String getValue() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            b.append(Strings.escape((String)this.values[i]));
            if (i >= this.values.length - 1) continue;
            b.append(';');
        }
        return b.toString();
    }

    public void setValue(String value) {
        this.values = value.split(VALUES_SPLIT_REGEX);
    }

    public ValidationResult validate() throws ValidationException {
        return ORG.validate((Object)this);
    }

    protected PropertyFactory<Org> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Org> {
        public Factory() {
            super(new String[]{PropertyName.ORG.toString()});
        }

        public Org createProperty(ParameterList params, String value) {
            return new Org(params, value);
        }

        @Override
        public Org createProperty(Group group, ParameterList params, String value) {
            return new Org(group, params, value);
        }
    }
}

