/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import net.fortuna.ical4j.model.CalendarDateFormat;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.TemporalAdapter;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.UtcProperty;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.DateFormatSupport;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;

public class Revision
extends DateProperty<Instant>
implements UtcProperty,
PropertyValidatorSupport {
    private static final long serialVersionUID = -1342640230576672871L;

    public Revision(Instant date) {
        super(PropertyName.REV.toString(), CalendarDateFormat.UTC_DATE_TIME_FORMAT, Value.DATE_TIME);
        this.setDate(date);
    }

    public Revision(ParameterList params, String value) {
        super(PropertyName.REV.toString(), params, CalendarDateFormat.UTC_DATE_TIME_FORMAT, Value.DATE_TIME);
        this.setValue(value);
    }

    public void setValue(String value) {
        try {
            super.setValue(value);
        }
        catch (DateTimeParseException e) {
            this.setDate(Instant.from(TemporalAdapter.parse((String)value, (CalendarDateFormat)DateFormatSupport.RELAXED_PARSE_FORMAT).getTemporal()));
        }
    }

    public ValidationResult validate() throws ValidationException {
        return REV.validate((Object)this);
    }

    protected PropertyFactory<Revision> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Revision> {
        public Factory() {
            super(new String[]{PropertyName.REV.toString()});
        }

        public Revision createProperty(ParameterList params, String value) {
            return new Revision(params, value);
        }

        @Override
        public Revision createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

