/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Value;

public class Uid
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = -7120539613021006347L;
    private URI uri;

    public Uid(URI uri) {
        super(PropertyName.UID.toString());
        this.uri = uri;
    }

    public Uid(ParameterList params, String value) {
        super(PropertyName.UID.toString(), params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String value) {
        try {
            this.uri = new URI(value);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return UID_TEXT.validate((Object)this);
        }
        return UID_URI.validate((Object)this);
    }

    protected PropertyFactory<Uid> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Uid> {
        public Factory() {
            super(new String[]{PropertyName.UID.toString()});
        }

        public Uid createProperty(ParameterList params, String value) {
            return new Uid(params, value);
        }

        @Override
        public Uid createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

