/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Type;
import org.apache.commons.lang3.StringUtils;

public class Address
extends Property
implements PropertyValidatorSupport,
GroupProperty {
    private static final long serialVersionUID = 6538745668985015384L;
    private String poBox;
    private String extended;
    private String street;
    private String locality;
    private String region;
    private String postcode;
    private String country;

    public Address(String poBox, String extended, String street, String locality, String region, String postcode, String country, Type ... types) {
        super((Enum)PropertyName.ADR);
        this.poBox = poBox;
        this.extended = extended;
        this.street = street;
        this.locality = locality;
        this.region = region;
        this.postcode = postcode;
        this.country = country;
        for (Type type : types) {
            this.add(type);
        }
    }

    @Deprecated
    public Address(Group group, String poBox, String extended, String street, String locality, String region, String postcode, String country, Type ... types) {
        this(poBox, extended, street, locality, region, postcode, country, types);
        this.setGroup(group);
    }

    public Address(ParameterList params, String value) {
        super((Enum)PropertyName.ADR, params);
        if (CompatibilityHints.isHintEnabled((String)"ical4j.parsing.relaxed")) {
            this.parseValueRelaxed(value);
        } else {
            this.parseValue(value);
        }
    }

    @Deprecated
    public Address(Group group, ParameterList params, String value) {
        this(params, value);
        this.setGroup(group);
    }

    private Address() {
        super((Enum)PropertyName.ADR);
    }

    public void setValue(String aValue) {
        this.parseValue(aValue);
    }

    private void parseValue(String value) {
        String[] components = value.split(";", 8);
        if (components.length < 6) {
            throw new IllegalArgumentException("ADR value must have all address components");
        }
        this.poBox = components[0];
        this.extended = components[1];
        this.street = components[2];
        this.locality = components[3];
        this.region = components[4];
        this.postcode = components[5];
        if (components.length > 6) {
            this.country = components[6];
        }
    }

    private void parseValueRelaxed(String value) {
        String[] components = value.split(";");
        int length = components.length;
        this.poBox = length >= 1 ? components[0] : "";
        this.extended = length >= 2 ? components[1] : "";
        this.street = length >= 3 ? components[2] : "";
        this.locality = length >= 4 ? components[3] : "";
        this.region = length >= 5 ? components[4] : "";
        this.postcode = length >= 6 ? components[5] : null;
        this.country = length >= 7 ? components[6] : null;
    }

    public String getPoBox() {
        return this.poBox;
    }

    public String getExtended() {
        return this.extended;
    }

    public String getStreet() {
        return this.street;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getValue() {
        StringBuilder b = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.poBox)) {
            b.append(Strings.escape((String)this.poBox));
        }
        b.append(';');
        if (StringUtils.isNotEmpty((CharSequence)this.extended)) {
            b.append(Strings.escape((String)this.extended));
        }
        b.append(';');
        if (StringUtils.isNotEmpty((CharSequence)this.street)) {
            b.append(Strings.escape((String)this.street));
        }
        b.append(';');
        if (StringUtils.isNotEmpty((CharSequence)this.locality)) {
            b.append(Strings.escape((String)this.locality));
        }
        b.append(';');
        if (StringUtils.isNotEmpty((CharSequence)this.region)) {
            b.append(Strings.escape((String)this.region));
        }
        b.append(';');
        if (StringUtils.isNotEmpty((CharSequence)this.postcode)) {
            b.append(Strings.escape((String)this.postcode));
        }
        b.append(';');
        if (StringUtils.isNotEmpty((CharSequence)this.country)) {
            b.append(Strings.escape((String)this.country));
        }
        b.append(';');
        return b.toString();
    }

    public ValidationResult validate() throws ValidationException {
        return ADDRESS.validate((Object)this);
    }

    protected net.fortuna.ical4j.model.PropertyFactory<?> newFactory() {
        return new Factory();
    }

    public static class Builder {
        private String poBox;
        private String extended;
        private String street;
        private String locality;
        private String region;
        private String postcode;
        private String country;

        public Builder poBox(String poBox) {
            this.poBox = poBox;
            return this;
        }

        public Builder extended(String extended) {
            this.extended = extended;
            return this;
        }

        public Builder street(String street) {
            this.street = street;
            return this;
        }

        public Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder postcode(String postcode) {
            this.postcode = postcode;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Address build() {
            Address address = new Address();
            address.poBox = this.poBox;
            address.extended = this.extended;
            address.street = this.street;
            address.locality = this.locality;
            address.region = this.region;
            address.postcode = this.postcode;
            address.country = this.country;
            return address;
        }
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Address> {
        public Factory() {
            super(new String[]{PropertyName.ADR.toString()});
        }

        public Address createProperty(ParameterList params, String value) {
            return new Address(params, Strings.unescape((String)value));
        }

        @Override
        public Address createProperty(Group group, ParameterList params, String value) {
            return new Address(group, params, Strings.unescape((String)value));
        }
    }
}

