/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Type;

public class Impp
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = 4042305605468586600L;
    private URI uri;

    public Impp(URI uri, Type ... types) {
        super(PropertyName.IMPP.toString());
        this.uri = uri;
        for (Type type : types) {
            this.add(type);
        }
    }

    public Impp(ParameterList params, String value) {
        super(PropertyName.IMPP.toString(), params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String value) {
        try {
            this.uri = new URI(value);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        return IMPP.validate((Object)this);
    }

    protected PropertyFactory<Impp> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Impp> {
        public Factory() {
            super(new String[]{PropertyName.IMPP.toString()});
        }

        public Impp createProperty(ParameterList params, String value) {
            return new Impp(params, value);
        }

        @Override
        public Impp createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

