/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Value;

public class SocialProfile
extends Property
implements PropertyValidatorSupport {
    private URI uri;
    private String value;

    public SocialProfile(String value) {
        super(PropertyName.SOCIALPROFILE.toString());
        this.setValue(value);
    }

    public SocialProfile(ParameterList aList, String value) {
        super(PropertyName.SOCIALPROFILE.toString(), aList);
        this.setValue(value);
    }

    public void setValue(String aValue) {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            this.value = aValue;
        } else {
            try {
                this.uri = new URI(aValue);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public ValidationResult validate() throws ValidationException {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return SOCIAL_PROFILE_TEXT_VALIDATOR.validate((Object)this);
        }
        return SOCIAL_PROFILE_URI_VALIDATOR.validate((Object)this);
    }

    protected net.fortuna.ical4j.model.PropertyFactory<?> newFactory() {
        return new Factory();
    }

    public String getValue() {
        if (this.uri != null) {
            return Strings.valueOf((Object)this.uri);
        }
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<SocialProfile> {
        public Factory() {
            super(new String[]{PropertyName.SOCIALPROFILE.toString()});
        }

        public SocialProfile createProperty(ParameterList parameters, String value) {
            return new SocialProfile(parameters, value);
        }
    }
}

