/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Encoding;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.parameter.Value;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Sound
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = -3293436282728289163L;
    private URI uri;
    private byte[] binary;
    private final Log log = LogFactory.getLog(Sound.class);

    public Sound(URI uri) {
        super(PropertyName.SOUND.toString());
        this.uri = uri;
        this.add(Value.URI);
    }

    public Sound(byte[] binary) {
        this(binary, null);
    }

    public Sound(byte[] binary, Type contentType) {
        super(PropertyName.SOUND.toString());
        this.binary = binary;
        this.add(Encoding.B);
        if (contentType != null) {
            this.add(contentType);
        }
    }

    public Sound(ParameterList params, String value) {
        super(PropertyName.SOUND.toString(), params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public String getValue() {
        String stringValue = null;
        if (Optional.of(Value.URI).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            stringValue = Strings.valueOf((Object)this.uri);
        } else if (this.binary != null) {
            try {
                Base64 encoder = new Base64();
                stringValue = new String(encoder.encode(this.binary));
            }
            catch (EncoderException ee) {
                this.log.error((Object)"Error encoding binary data", (Throwable)ee);
            }
        }
        return stringValue;
    }

    public void setValue(String value) {
        Optional valueParameter = this.getParameter(ParameterName.VALUE.toString());
        if (valueParameter.isPresent() && "URL".equalsIgnoreCase(((Parameter)valueParameter.get()).getValue())) {
            try {
                this.uri = new URI(value);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Base64 decoder = new Base64();
        try {
            this.binary = decoder.decode(value.getBytes());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        return SOUND.validate((Object)this);
    }

    protected PropertyFactory<Sound> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Sound> {
        public Factory() {
            super(new String[]{PropertyName.SOUND.toString()});
        }

        public Sound createProperty(ParameterList params, String value) {
            return new Sound(params, value);
        }

        @Override
        public Sound createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

