/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;

public class Source
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = -8097388189864368448L;
    private URI uri;

    public Source(URI uri) {
        super(PropertyName.SOURCE.toString());
        this.uri = uri;
    }

    public Source(ParameterList params, String value) {
        super(PropertyName.SOURCE.toString(), params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        return this.uri.toString();
    }

    public void setValue(String value) {
        try {
            this.uri = new URI(value);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        return SOURCE.validate((Object)this);
    }

    protected PropertyFactory<Source> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Source> {
        public Factory() {
            super(new String[]{PropertyName.SOURCE.toString()});
        }

        public Source createProperty(ParameterList params, String value) {
            return new Source(params, value);
        }

        @Override
        public Source createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

