/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fortuna.ical4j.filter.predicate.PropertyEqualToRule;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardContainer;
import net.fortuna.ical4j.vcard.VCardList;
import net.fortuna.ical4j.vcard.property.Uid;

public class VCardGroup
implements VCardContainer {
    private VCardList cardList;
    private final Predicate<VCard> cardPredicate;

    public VCardGroup(Uid uid) {
        this(uid, new VCardList());
    }

    public VCardGroup(Uid uid, VCardList cardList) {
        this.cardPredicate = new PropertyEqualToRule((Comparable)((Object)uid));
        this.cardList = cardList;
    }

    @Override
    public VCardList getVCardList() {
        return this.cardList;
    }

    @Override
    public void setVCardList(VCardList cards) {
        this.cardList = cards;
    }

    public List<VCard> getRevisions() {
        return this.cardList.getAll().stream().filter(this.cardPredicate).sorted().collect(Collectors.toList());
    }

    public VCard getLatestRevision() {
        return this.getRevisions().get(0);
    }

    @Override
    public VCardContainer add(VCard component) {
        if (!this.cardPredicate.test(component)) {
            throw new IllegalArgumentException("Invalid component for this group");
        }
        return VCardContainer.super.add(component);
    }
}

