/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.filter;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fortuna.ical4j.filter.AbstractFilter;
import net.fortuna.ical4j.filter.FilterExpression;
import net.fortuna.ical4j.filter.expression.BinaryExpression;
import net.fortuna.ical4j.filter.expression.UnaryExpression;
import net.fortuna.ical4j.filter.predicate.PropertyContainsRule;
import net.fortuna.ical4j.filter.predicate.PropertyEqualToRule;
import net.fortuna.ical4j.filter.predicate.PropertyExistsRule;
import net.fortuna.ical4j.filter.predicate.PropertyGreaterThanRule;
import net.fortuna.ical4j.filter.predicate.PropertyInRangeRule;
import net.fortuna.ical4j.filter.predicate.PropertyInRule;
import net.fortuna.ical4j.filter.predicate.PropertyLessThanRule;
import net.fortuna.ical4j.filter.predicate.PropertyMatchesRule;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.vcard.VCard;

public class VCardFilter
extends AbstractFilter<VCard> {
    public VCardFilter() {
    }

    public VCardFilter(Supplier<List<PropertyFactory<?>>> propertyFactorySupplier, Supplier<List<ParameterFactory<?>>> parameterFactorySupplier) {
        super(propertyFactorySupplier, parameterFactorySupplier);
    }

    public Predicate<VCard> predicate(UnaryExpression expression) {
        switch (expression.operator) {
            case not: {
                return this.predicate(expression.operand).negate();
            }
            case exists: {
                return new PropertyExistsRule(this.property(expression));
            }
            case notExists: {
                return new PropertyExistsRule(this.property(expression)).negate();
            }
        }
        throw new IllegalArgumentException("Not a valid filter");
    }

    public Predicate<VCard> predicate(BinaryExpression expression) {
        switch (expression.operator) {
            case and: {
                return this.predicate(expression.left).and(this.predicate(expression.right));
            }
            case or: {
                return this.predicate(expression.left).or(this.predicate(expression.right));
            }
            case equalTo: {
                return new PropertyEqualToRule((Comparable)this.property(expression));
            }
            case notEqualTo: {
                return new PropertyEqualToRule((Comparable)this.property(expression)).negate();
            }
            case in: {
                return new PropertyInRule((Collection)this.properties(expression));
            }
            case notIn: {
                return new PropertyInRule((Collection)this.properties(expression)).negate();
            }
            case greaterThan: {
                return new PropertyGreaterThanRule((Comparable)this.property(expression));
            }
            case greaterThanEqual: {
                return new PropertyGreaterThanRule((Comparable)this.property(expression), true);
            }
            case lessThan: {
                return new PropertyLessThanRule((Comparable)this.property(expression));
            }
            case lessThanEqual: {
                return new PropertyLessThanRule((Comparable)this.property(expression), true);
            }
            case between: {
                List properties = this.properties(expression);
                return new PropertyInRangeRule((Comparable)properties.get(0), (Comparable)properties.get(1), true);
            }
            case contains: {
                return new PropertyContainsRule(this.property(expression), (String)this.literal((FilterExpression)expression));
            }
            case matches: {
                return new PropertyMatchesRule(this.property(expression), (String)this.literal((FilterExpression)expression));
            }
        }
        throw new IllegalArgumentException("Not a valid filter");
    }
}

