/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.parameter;

import java.util.Locale;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.vcard.ParameterFactory;
import net.fortuna.ical4j.vcard.ParameterName;
import org.apache.commons.lang3.StringUtils;

public final class Language
extends Parameter {
    private static final long serialVersionUID = 8762124184853766503L;
    private final Locale locale;

    public Language(String value) {
        this(new Locale(value));
    }

    public Language(Locale locale) {
        super(ParameterName.LANGUAGE.toString());
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getValue() {
        StringBuilder b = new StringBuilder();
        b.append(this.locale.getLanguage());
        if (!StringUtils.isEmpty((CharSequence)this.locale.getCountry())) {
            b.append('-');
            b.append(this.locale.getCountry());
        }
        if (!StringUtils.isEmpty((CharSequence)this.locale.getVariant())) {
            b.append('-');
            b.append(this.locale.getVariant());
        }
        return b.toString();
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Language> {
        public Factory() {
            super(new String[]{ParameterName.LANGUAGE.toString()});
        }

        public Language createParameter(String value) {
            return new Language(new Locale(value));
        }
    }
}

