/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.time.temporal.Temporal;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Value;

public class Anniversary<T extends Temporal>
extends DateProperty<T>
implements Encodable,
PropertyValidatorSupport {
    private static final long serialVersionUID = 3009228294165154307L;
    private String value;

    public Anniversary(String value) {
        super(PropertyName.ANNIVERSARY.toString());
        this.value = value;
    }

    public Anniversary(ParameterList params, String value) {
        super(PropertyName.ANNIVERSARY.toString(), params);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public ValidationResult validate() throws ValidationException {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return ANNIVERSARY_TEXT.validate((Object)this);
        }
        return ANNIVERSARY_DATE.validate((Object)this);
    }

    protected PropertyFactory<Anniversary<T>> newFactory() {
        return new Factory();
    }

    public static class Factory<T extends Temporal>
    extends Content.Factory
    implements PropertyFactory<Anniversary<T>> {
        public Factory() {
            super(new String[]{PropertyName.ANNIVERSARY.toString()});
        }

        public Anniversary<T> createProperty(ParameterList params, String value) {
            return new Anniversary(params, Strings.unescape((String)value));
        }

        @Override
        public Anniversary<T> createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

