/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.Optional;
import net.fortuna.ical4j.model.CalendarDateFormat;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.TemporalAdapter;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.DateFormatSupport;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Value;

public class BDay<T extends Temporal>
extends DateProperty<T>
implements Encodable,
PropertyValidatorSupport {
    private static final long serialVersionUID = 4298026868242865633L;
    private String text;

    public BDay(T date) {
        super(PropertyName.BDAY.toString());
        this.setDate((Temporal)date);
    }

    public BDay(String text) {
        super(PropertyName.BDAY.toString());
        this.text = text;
        this.add(Value.TEXT);
    }

    public BDay(ParameterList params, String value) {
        super(PropertyName.BDAY.toString(), params);
        this.setValue(value);
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return this.text;
        }
        return super.getValue();
    }

    public void setValue(String value) {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            this.text = value;
        } else {
            try {
                super.setValue(value);
            }
            catch (DateTimeParseException e) {
                this.setDate(TemporalAdapter.parse((String)value, (CalendarDateFormat)DateFormatSupport.RELAXED_PARSE_FORMAT).getTemporal());
            }
        }
    }

    public ValidationResult validate() throws ValidationException {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return BDAY_TEXT.validate((Object)this);
        }
        return BDAY_DATE.validate((Object)this);
    }

    protected PropertyFactory<BDay<T>> newFactory() {
        return new Factory();
    }

    public static class Factory<T extends Temporal>
    extends Content.Factory
    implements PropertyFactory<BDay<T>> {
        public Factory() {
            super(new String[]{PropertyName.BDAY.toString()});
        }

        public BDay<T> createProperty(ParameterList params, String value) {
            return new BDay(params, Strings.unescape((String)value));
        }

        @Override
        public BDay<T> createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

