/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Encoding;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.parameter.Value;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Key
extends Property
implements PropertyValidatorSupport,
GroupProperty {
    private static final long serialVersionUID = -6645173064940148955L;
    private URI uri;
    private byte[] binary;
    private final Logger log = LoggerFactory.getLogger(Key.class);

    public Key(URI uri) {
        super(PropertyName.KEY.toString());
        this.uri = uri;
        this.add(Value.URI);
    }

    public Key(byte[] binary) {
        this(binary, null);
    }

    public Key(byte[] binary, Type contentType) {
        super(PropertyName.KEY.toString());
        this.binary = binary;
        this.add(Encoding.B);
        if (contentType != null) {
            this.add(contentType);
        }
    }

    public Key(ParameterList params, String value) {
        super(PropertyName.KEY.toString(), params);
        this.setValue(value);
    }

    @Deprecated
    public Key(Group group, ParameterList params, String value) {
        this(params, value);
        this.setGroup(group);
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public String getValue() {
        Optional valueParameter = this.getParameter(ParameterName.VALUE.toString());
        String stringValue = null;
        if (valueParameter.isPresent() && "URL".equalsIgnoreCase(((Parameter)valueParameter.get()).getValue())) {
            stringValue = Strings.valueOf((Object)this.uri);
        } else if (this.binary != null) {
            try {
                Base64 encoder = new Base64();
                stringValue = new String(encoder.encode(this.binary));
            }
            catch (EncoderException ee) {
                this.log.error("Error encoding binary data", (Throwable)ee);
            }
        }
        return stringValue;
    }

    public void setValue(String value) {
        Optional valueParameter = this.getParameter(ParameterName.VALUE.toString());
        if (valueParameter.isPresent() && "URL".equalsIgnoreCase(((Parameter)valueParameter.get()).getValue())) {
            try {
                this.uri = new URI(value);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Base64 decoder = new Base64();
        try {
            this.binary = decoder.decode(value.getBytes());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return KEY_TEXT.validate((Object)this);
        }
        return KEY_URI.validate((Object)this);
    }

    protected PropertyFactory<Key> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Key> {
        public Factory() {
            super(new String[]{PropertyName.KEY.toString()});
        }

        public Key createProperty(ParameterList params, String value) {
            return new Key(params, value);
        }

        @Override
        public Key createProperty(Group group, ParameterList params, String value) {
            return new Key(group, params, value);
        }
    }
}

