/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.property.Uid;

public class Member
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = 6622845049765958916L;
    private URI uri;

    public Member(URI uri) {
        super((Enum)PropertyName.MEMBER);
        this.uri = uri;
    }

    public Member(VCard card) {
        super((Enum)PropertyName.MEMBER);
        Uid uid = (Uid)card.getRequiredProperty(PropertyName.UID);
        this.setUri(uid.getUri());
    }

    public Member(ParameterList params, String value) {
        super((Enum)PropertyName.MEMBER, params);
        this.setValue(value);
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String value) {
        try {
            this.uri = new URI(value);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        return MEMBER.validate((Object)this);
    }

    protected PropertyFactory<Member> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Member> {
        public Factory() {
            super(new String[]{PropertyName.MEMBER.toString()});
        }

        public Member createProperty(ParameterList params, String value) {
            return new Member(params, value);
        }

        @Override
        public Member createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

