/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;

public class Nickname
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = 2512809288464680577L;
    private String[] names;

    public Nickname(String ... names) {
        super(PropertyName.NICKNAME.toString());
        if (names.length == 0) {
            throw new IllegalArgumentException("Must specify at least one nickname");
        }
        this.names = names;
    }

    public Nickname(ParameterList params, String value) {
        super(PropertyName.NICKNAME.toString(), params);
        this.names = value.split(",");
    }

    public String[] getNames() {
        return this.names;
    }

    public String getValue() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append(this.names[i]);
        }
        return b.toString();
    }

    public void setValue(String value) {
        this.names = value.split(",");
    }

    public ValidationResult validate() throws ValidationException {
        return NICKNAME.validate((Object)this);
    }

    protected PropertyFactory<Nickname> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Nickname> {
        public Factory() {
            super(new String[]{PropertyName.NICKNAME.toString()});
        }

        public Nickname createProperty(ParameterList params, String value) {
            return new Nickname(params, value);
        }

        @Override
        public Nickname createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

