/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.parameter.Value;
import net.fortuna.ical4j.vcard.property.Uid;

public class Related
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = -3319959600372278036L;
    public static Type TYPE_CONTACT = new Type("contact");
    public static Type TYPE_ACQUAINTANCE = new Type("acquaintance");
    public static Type TYPE_FRIEND = new Type("friend");
    public static Type TYPE_MET = new Type("met");
    public static Type TYPE_COWORKER = new Type("co-worker");
    public static Type TYPE_COLLEAGUE = new Type("colleague");
    public static Type TYPE_CORESIDENT = new Type("co-resident");
    public static Type TYPE_NEIGHBOR = new Type("neighbor");
    public static Type TYPE_CHILD = new Type("child");
    public static Type TYPE_PARENT = new Type("parent");
    public static Type TYPE_SIBLING = new Type("sibling");
    public static Type TYPE_SPOUSE = new Type("spouse");
    public static Type TYPE_KIN = new Type("kin");
    public static Type TYPE_MUSE = new Type("muse");
    public static Type TYPE_CRUSH = new Type("crush");
    public static Type TYPE_DATE = new Type("date");
    public static Type TYPE_SWEETHEART = new Type("sweetheart");
    public static Type TYPE_ME = new Type("me");
    public static Type TYPE_AGENT = new Type("agent");
    public static Type TYPE_EMERGENCY = new Type("emergency");
    private URI uri;
    private String text;

    public Related(VCard card, Type ... types) {
        super((Enum)PropertyName.RELATED);
        Uid cardUid = (Uid)card.getRequiredProperty(PropertyName.UID);
        this.uri = cardUid.getUri();
        this.add(Value.URI);
        Arrays.stream(types).forEach(arg_0 -> ((Related)this).add(arg_0));
    }

    public Related(String text, Type ... types) {
        super((Enum)PropertyName.RELATED);
        this.text = text;
        this.add(Value.TEXT);
        Arrays.stream(types).forEach(arg_0 -> ((Related)this).add(arg_0));
    }

    public Related(URI uri, Type ... types) {
        super((Enum)PropertyName.RELATED);
        this.uri = uri;
        Arrays.stream(types).forEach(arg_0 -> ((Related)this).add(arg_0));
    }

    public Related(ParameterList params, String value) {
        super((Enum)PropertyName.RELATED, params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return this.text;
        }
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String value) {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            this.text = value;
        } else {
            try {
                this.uri = new URI(value);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public ValidationResult validate() throws ValidationException {
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return RELATED_TEXT.validate((Object)this);
        }
        return RELATED_URI.validate((Object)this);
    }

    protected PropertyFactory<Related> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Related> {
        public Factory() {
            super(new String[]{PropertyName.RELATED.toString()});
        }

        public Related createProperty(ParameterList params, String value) {
            return new Related(params, value);
        }

        @Override
        public Related createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

